<?php
/* --------------------------------------------------------------
  StoredBoilerplateConfigCollection.inc.php 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

namespace StyleEdit\Collections;

use StyleEdit\Entities\StoredBoilerplateConfig;

/**
 * Class StoredBoilerplateConfigCollection
 *
 * @package StyleEdit\Collections
 */
class StoredBoilerplateConfigCollection extends Collection
{
	/**
	 * Returns the value of a collection item addressed by the key. If the key is not a string or unknown,
	 * an exception will be thrown.
	 *
	 * @param $p_key
	 *
	 * @throws \InvalidArgumentException if $p_key is not a string
	 * @throws \InvalidArgumentException if $p_key is unknown
	 * @throws \InvalidArgumentException if the item matching the key is not an instance of StoredBoilerplateConfig
	 *
	 * @return mixed
	 */
	public function getItem($p_key)
	{
		$item = parent::getItem($p_key);
		
		if(!$item instanceof StoredBoilerplateConfig)
		{
			throw new \InvalidArgumentException('The item matching the key is not an instance of StoredBoilerplateConfig');
		}
		
		return $item;
	}
}